//
//  Sprite.h
//  Engine
//
//  Created by ss2cire on 10/9/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import <Cocoa/Cocoa.h>
#import <OpenGL/gl.h>
#import "Common.h"

@interface Sprite : NSObject <Common>
{
	int locationX;
	int locationY;
	
	GLuint	textureID;
	BOOL hasTexture;
	NSSize size;
}

- (id)initWithLocationX:(int)locX locationY:(int)locY andSize:(NSSize)inSize;
- (void)setTexture:(GLuint)texID;
- (void)draw;
- (void)update;

@end
